---
sidebar_position: 1
title: Introduction
---

## CrestApps - Laravel Code Generator

### Introduction

Enhance your Laravel development experience with our sophisticated code generator! This powerful tool is designed to streamline your workflow and save you valuable time. Whether you need to create views, controllers, routes, migrations, languages, or request forms, this versatile generator has got you covered – all in just seconds!

Experience the ultimate flexibility and customization options to cater to a wide range of use cases. Our code generator comes with a cross-browser compatible template and includes client-side validation to bring a modern touch to your application.

Explore the project's source code on [GitHub](https://github.com/CrestApps/laravel-code-generator), available under the permissive [MIT license](https://opensource.org/licenses/MIT). Upgrade your Laravel development with efficiency and style!


### Features

- Craft clean, reusable, and highly readable code for seamless development.
- Generate complete resources effortlessly with a single command, supporting both migration and existing database scenarios.
- Streamline resource creation for all existing database tables with a single command.
- Save and recreate fields using a JSON file, ensuring adaptability to changing business needs.
- Leverage JSON-based resource files for easy regeneration, even when business rules evolve.
- Generate standard CRUD controllers with simple or form-request validation.
- Customize view templates to alter the standard look and feel of your application.
- Create models with relations for comprehensive data representation.
- Establish named routes with and without grouping for efficient navigation.
- Generate standard CRUD views to facilitate a consistent user experience.
- Smart migration engine tracks generated migrations to only create necessary ones.
- Intelligent handling of model relations to simplify development.
- Highly flexible with rich configurable options to suit diverse needs.
- Easy commands for resource-file creation, addition, or reduction.
- Full support for generating multi-language applications.
- Implement client-side validation for enhanced user interaction.
- Efficiently handle file uploading and store multiple responses in the database.
- Generate form-request to clean up controllers and boost code reusability.
- Create view layouts with and without client-side validation.
- Change templates at runtime for diverse view generation.
- Ability to generate views with or without Laravel-Collective integration.
- Seamless handling of date, time, or datetime fields.
- Automatic management of boolean fields for hassle-free development.


### Dependencies

#### Prerequisite

 - **[Laravel >= 5.1 framework.](https://laravel.com/)**
 - **[Composer](https://getcomposer.org/)** installed on your local workstation.

#### Default template dependencies

 - **[CSS bootstrap Framework.](http://getbootstrap.com/)** This is only required with the default template. You are free to make your own template.
