<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('sell_bars', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('item_id');
            $table->integer('qty')->nullable();
            $table->decimal('weight', 64, 3)->nullable();
            $table->timestamp('dateInsert')->nullable();
            $table->integer('rate')->nullable();
            $table->unsignedBigInteger('user_id');
            $table->boolean('isdelete')->default(0);
            $table->integer('purchase_price')->nullable();
            $table->integer('sell_price')->nullable();
            $table->timestamp('expiry_date')->nullable();
            $table->text('description')->nullable();
            $table->timestamps();
            $table->unsignedBigInteger('accounts_id')->default(0)->nullable();
            $table->unsignedBigInteger('bill_id')->nullable();
            $table->unsignedBigInteger('return_purchase_id')->nullable();
            $table->unsignedBigInteger('money_id')->nullable();
            $table->unsignedBigInteger('purchase_id')->nullable();
            $table->unsignedBigInteger('cobin_id')->nullable();

            // Foreign keys (در صورت نیاز می‌توان فعال کرد)
            // $table->foreign('item_id')->references('id')->on('items');
            // $table->foreign('user_id')->references('id')->on('users');
            // $table->foreign('accounts_id')->references('id')->on('accounts');
            // $table->foreign('bill_id')->references('id')->on('bills');
            // $table->foreign('return_purchase_id')->references('id')->on('return_purchases');
            // $table->foreign('money_id')->references('id')->on('money');
            // $table->foreign('purchase_id')->references('id')->on('purchases');
            // $table->foreign('cobin_id')->references('id')->on('cobins');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('sell_bars');
    }
};
