<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Exchange extends Model
{
    use HasFactory;
     protected $fillable = [
        'from_account_id',
        'to_account_id',
        'com_account_id',
        'description',
        'rate',
        'rate_type',
        'type',
        'date',
        'from_money_id',
        'to_money_id',
        'from_amount',
        'to_amount',
        'com_amount',
        'user_id',
        'isdelete'
    ];
    public function fromAccount()
    {
        return $this->belongsTo(Belances::class, 'from_account_id');
    }
    public function toAccount()
    {
        return $this->belongsTo(Belances::class, 'to_account_id');
    }
    public function fromMoney()
    {
        return $this->belongsTo(Moneys::class, 'from_money_id');
    }
    public function toMoney()
    {
        return $this->belongsTo(Moneys::class, 'to_money_id');
    }
    // public function comAccount()
    // {
    //     return $this->belongsTo(Belances::class, 'com_account_id');
    // }
    public function user(){
        return $this->belongsTo(User::class,'user_id');
    }

}