<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CabinStock extends Model
{
    use HasFactory;

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'cabin_stocks'; // Replace with your actual table name

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'item_id',
        'cobin_id',
        'qty',
        'weight',
        'dateInsert',
        'rate',
        'user_id',
        'purchase_price',
        'expiry_date',
        'description',
        'money_id'
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'dateInsert' => 'datetime',
        'expiry_date' => 'datetime',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
        'weight' => 'decimal:3',
        'qty' => 'decimal:2',
        'rate' => 'integer',
        'purchase_price' => 'integer'
    ];

    /**
     * The primary key for the model.
     *
     * @var string
     */
    protected $primaryKey = 'id';

    /**
     * Indicates if the IDs are auto-incrementing.
     *
     * @var bool
     */
    public $incrementing = true;

    /**
     * The data type of the auto-incrementing ID.
     *
     * @var string
     */
    protected $keyType = 'int';

    /**
     * Get the user that owns the record.
     */
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    /**
     * Get the item that owns the record.
     */
    public function item()
    {
        return $this->belongsTo(Item::class); // Assuming you have an Item model
    }

    /**
     * Get the money that owns the record.
     */
    public function money()
    {
        return $this->belongsTo(Moneys::class,'money_id'); // Assuming you have a Money model
    }

    /**
     * Get the cobin that owns the record.
     */
    public function cobin()
    {
        return $this->belongsTo(cabinet::class, 'cobin_id'); // Assuming you have a Cobin model
    }
}