<?php
namespace App\Http\Controllers;
use App\Models\SiteSetting;
use Illuminate\Http\Request;

class SiteSettingController extends Controller
{
    // [C] Create
    public function store(Request $request)
    {
        $validated = $request->validate([
            'key' => 'required|unique:site_settings,key',
            'value' => 'nullable|string',
            'type' => 'nullable|string',
            'description' => 'nullable|string',
        ]);

        SiteSetting::create($validated);

        return response()->json(['message' => 'تنظیم جدید ثبت شد.']);
    }

    // [R] Read all
    public function index()
    {
        return SiteSetting::all();
    }

    // [R] Read one
    public function show($key)
    {
        return SiteSetting::findOrFail($key);
    }

    // [U] Update
    public function update(Request $request, $key)
    {
        $setting = SiteSetting::findOrFail($key);

        $setting->update([
            'value' => $request->input('value'),
            'type' => $request->input('type'),
            'description' => $request->input('description'),
        ]);

        return response()->json(['message' => 'تنظیمات به‌روزرسانی شد.']);
    }

    // [D] Delete
    public function destroy($key)
    {
        $setting = SiteSetting::findOrFail($key);
        $setting->delete();

        return response()->json(['message' => 'تنظیم حذف شد.']);
    }
}
