<?php
namespace App\Http\Controllers;
use Illuminate\Http\Request;
use App\Models\Sidebar;
class SidebarController extends Controller
{
    public function index()
    {
        $itemTypes = Sidebar::get();
        return response()->json($itemTypes);
    }

    // /**
    //  * Store a new item type in the storage.
    //  *
    //  * @param Illuminate\Http\Request $request
    //  *
    //  * @return \Illuminate\Http\JsonResponse
    //  */
    public function store(Request $request)
    {
        $data = $this->getData($request);
        $itemType = Sidebar::create($data);

        return response()->json([
            'id' => $itemType->id,
            'message' => 'Item created successfully.'
        ], 201); // 201 Created
    }


    // /**
    //  * Display the specified item type.
    //  *
    //  * @param int $id
    //  *
    //  * @return \Illuminate\Http\JsonResponse
    //  */
    public function show($id)
    {
        $itemType = Sidebar::findOrFail($id);
        return response()->json($itemType);
    }

    // /**
    //  * Update the specified item type in the storage.
    //  *
    //  * @param int $id
    //  * @param Illuminate\Http\Request $request
    //  *
    //  * @return \Illuminate\Http\JsonResponse
    //  */
    public function update($id, Request $request)
    {
        $data = $this->getData($request);
    
        // پیدا کردن آیتم بر اساس شناسه
        
        $itemType = Sidebar::findOrFail($id);
        // اگر یک تصویر جدید ارسال شد
        // آپدیت داده‌ها در دیتابیس
        $itemType->update($data);
    
        // بازگشت پاسخ JSON از آیتم آپدیت شده
        return response()->json($itemType);
    }
    

    // /**
    //  * Get the request's data from the request.
    //  *
    //  * @param Illuminate\Http\Request $request
    //  * @return array
    //  */
    protected function getData(Request $request)
    {
        $rules = [
            "Accounts"=>"",
            "All_Draft_Group"=>"",
            "Cash"=>"",
            "Currency"=>"",
            "Customers"=>"",
            "Dashboard"=>"",
            "Deposite"=>"",
            "Draft_Accounts"=>"",
            "Draft_Currency"=>"",
            "Draft_Customers"=>"",
            "Draft_Transactions"=>"",
            "Item_Type"=>"",
            "Items"=>"",
            "Items_Group"=>"",
            "Purchase"=>"",
            "Purchase_Return"=>"",
            "Report_Customer"=>"",
            "Reports"=>"",
            "Sell"=>"",
            "Sell_Return"=>"",
            "Settings"=>"",
            "Stock"=>"",
            "Transactions_Group"=>"",
            "Transformation"=>"",
            "Withdraw"=>"",
            "benefit_report"=> "",
            "type"=>"",
            'cabinets'=>"", 
            'Cobin'=>"", 
            'CabinetManagement'=>"", 
            'TransferCabin'=>"", 
            'Purchasedashboard'=>"", 
            'Sellsdashboard'=>"",
        ];
        $data = $request->validate($rules);
        return $data;
    }

}
