<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
class RoleController extends Controller
{
    // لیست همه رول‌ها با پرمیشن‌ها
    public function index()
    {
        $roles = Role::with('permissions:id,name')->get(['id', 'name']);
        return response()->json([
            'success' => true,
            'data' => $roles
        ]);
    }

    // ساخت رول جدید با پرمیشن‌ها
    public function store(Request $request)
{
    $request->validate([
        'name' => '',
        'permissions' => 'array',
        'permissions.*' => 'string',
    ]);

    // ایجاد نقش با گارد مشخص
    $role = Role::create([
        'name' => $request->name,
        'guard_name' => 'web', // 👈 اینجا
    ]);

    if ($request->has('permissions')) {
        $permissions = collect($request->permissions)
            ->map(function ($name) {
                return Permission::where('name', $name)->where('guard_name', 'web')->firstOrFail(); // 👈 guard مشخص
            });

        $role->syncPermissions($permissions);
    }

    return response()->json([
        'success' => true,
        'message' => 'Role created successfully',
        'data' => $role->load('permissions:id,name'),
    ]);
}
    // نمایش یک رول خاص با پرمیشن‌ها
    public function show($id)
    {
        $role = Role::with('permissions:id,name')->find($id);

        if (!$role) {
            return response()->json([
                'success' => false,
                'message' => 'Role not found'
            ], 404);
        }
        return response()->json([
            'success' => true,
            'data' => $role
        ]);
    }

    // بروزرسانی رول و پرمیشن‌ها
    public function update(Request $request, $id)
    {
        $role = Role::find($id);

        if (!$role) {
            return response()->json([
                'success' => false,
                'message' => 'Role not found'
            ], 404);
        }
        
        $request->validate([
            'name' => '',
            'permissions' => 'array',
            'permissions.*' => 'string',
        ]);

        $role->update(['name' => $request['name']
        ,'guard_name' => 'web', // 👈 اینجا
    ]);


          if ($request->has('permissions')) {
                $permissions = collect($request->permissions)
                    ->map(function ($name) {
                        return Permission::where('name', $name)->where('guard_name', 'web')->firstOrFail(); // 👈 guard مشخص
                    });

                $role->syncPermissions($permissions);
            }
        return response()->json([
            'success' => true,
            'message' => 'Role updated successfully',
            'data' => $role->load('permissions:id,name')
        ]);
    }

    // حذف رول
    public function destroy($id)
    {
        $role = Role::find($id);

        if (!$role) {
            return response()->json([
                'success' => false,
                'message' => 'Role not found'
            ], 404);
        }

        $role->delete();

        return response()->json([
            'success' => true,
            'message' => 'Role deleted successfully'
        ]);
    }
}