<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Models\Accounts;
use App\Models\Bill;
use App\Models\Exchange;
use App\Models\Expense;
use App\Models\Purchasebills;
use App\Models\Report;
use App\Models\User;
use App\Models\Moneys; // Ensure this is the correct model name (capitalized)
use App\Models\Belances; // Ensure this is the correct model name (capitalized)
use Date;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use App\Http\Resources\MoneyResource;
use App\Http\Resources\BelanceResource;
use Illuminate\Support\Facades\DB;
use App\Models\CabinStock;
use Exception;
use Carbon\Carbon;


class MoneysController extends Controller
{
    /**
     * Display a listing of the accounts.
     *
     * @return \Illuminate\Http\JsonResponse
     * 
     * 
     */
    public function dateChange($date)
    {
        if ($date) {
            try {
                return Carbon::parse($date)->addDay()->format('Y-m-d');
            } catch (\Exception $e) {
                return response()->json(['error' => 'error'], 422);
            }
        }

        return null;
    }

    public function index(Request $request)
    {
        // $isdelete=$request->query('isdelete');
        $isdelete = $request->query('delete');
        $account_id = $request->query('account_id');
        $typeof = $request->query('type');
        $data = $request->query('EndDate');
        if ($typeof === 'cash') {
            $today = $data ? $this->dateChange($data) : Carbon::today()->format('Y-m-d');

            // $today = Carbon::today()->toDateString(); 
            $tommarow = Carbon::parse($today)->addDay()->format('Y-m-d'); // تاریخ دیروز
            $yesterday = Carbon::parse($today)->subDay()->format('Y-m-d'); // تاریخ دیروز
            $tommarow1 = Carbon::parse($tommarow)->addDay()->format('Y-m-d'); // تاریخ دیروز

            // تابع کمکی برای ساخت کوئری
            $getCashData = function ($date) {
                $startOfDay = Carbon::parse($date)->startOfDay()->toDateTimeString();
                $endOfDay = Carbon::parse($date)->endOfDay()->toDateTimeString();

                return Moneys::selectRaw("
        moneys.id,
        moneys.name,
        moneys.cach as current_cash,

        -- DAILY TOTALS (for specific date)
        -- Daily Deposits
        COALESCE(SUM(CASE WHEN reports.type = 'deposite' AND reports.isdelete = 0 
            AND reports.date_created BETWEEN ? AND ? THEN reports.amount ELSE 0 END), 0) as daily_deposits,

        -- Daily Withdraws
        COALESCE(SUM(CASE WHEN reports.type = 'withdraw' AND reports.isdelete = 0 
            AND reports.date_created BETWEEN ? AND ? THEN reports.amount ELSE 0 END), 0) as daily_withdraws,

        -- Daily Purchases
        COALESCE((
            SELECT SUM(pb.PaidAmount) 
            FROM purchasebills pb
            WHERE pb.money_id = moneys.id 
            AND pb.isdelete = 0
            AND pb.dateInsert BETWEEN ? AND ?
        ), 0) as daily_purchases,

        -- Daily Expenses
        COALESCE((
            SELECT SUM(ex.amount) 
            FROM expenses ex
            WHERE ex.money_id = moneys.id 
            AND ex.isdelete = 0
            AND ex.date BETWEEN ? AND ?
        ), 0) as daily_expenses,


        -- Daily cash_from_account
        COALESCE((
            SELECT SUM(ex.to_amount) 
            FROM exchanges ex
            WHERE ex.to_money_id = moneys.id 
            AND ex.isdelete = 0
            AND ex.type = 'cash_from_account'
            AND ex.date BETWEEN ? AND ?
        ), 0) as daily_cash_from_account,


        -- Daily account_from_cash
        COALESCE((
            SELECT SUM(ex.from_amount) 
            FROM exchanges ex
            WHERE ex.from_money_id = moneys.id 
            AND ex.isdelete = 0
            AND ex.type = 'account_from_cash'
            AND ex.date BETWEEN ? AND ?
        ), 0) as daily_account_from_cash,


        -- Daily Sales
        COALESCE((
            SELECT SUM(sb.PaidAmount) 
            FROM bills sb
            WHERE sb.money_id = moneys.id 
            AND sb.isdelete = 0
            AND sb.dateInsert BETWEEN ? AND ?
        ), 0) as daily_sales,

        -- Daily Transaction count
        COALESCE(COUNT(CASE WHEN reports.type IN ('deposite','withdraw') 
            AND reports.isdelete = 0 
            AND reports.date_created BETWEEN ? AND ? THEN reports.id END), 0) as daily_qty,

        -- CUMULATIVE TOTALS (for dates after given date)
        -- Cumulative Deposits
        COALESCE(SUM(CASE WHEN reports.type = 'deposite' AND reports.isdelete = 0 
            AND DATE(reports.date_created) > ? THEN reports.amount ELSE 0 END), 0) as cumulative_deposits,

        -- Cumulative Withdraws
        COALESCE(SUM(CASE WHEN reports.type = 'withdraw' AND reports.isdelete = 0 
            AND DATE(reports.date_created) > ? THEN reports.amount ELSE 0 END), 0) as cumulative_withdraws,

        -- Cumulative Purchases
        COALESCE((
            SELECT SUM(pb.PaidAmount) 
            FROM purchasebills pb
            WHERE pb.money_id = moneys.id 
            AND pb.isdelete = 0
            AND DATE(pb.dateInsert) > ?
        ), 0) as cumulative_purchases,

        -- Cumulative cash_from_account
        COALESCE((
            SELECT SUM(ex.to_amount) 
            FROM exchanges ex
            WHERE ex.to_money_id = moneys.id 
            AND ex.isdelete = 0
            AND ex.type = 'cash_from_account'
            AND DATE(ex.date) > ?
        ), 0) as cumulative_cash_from_account,




        -- Cumulative account_from_cash
        COALESCE((
            SELECT SUM(ex.from_amount) 
            FROM exchanges ex
            WHERE ex.from_money_id = moneys.id 
            AND ex.isdelete = 0
            AND ex.type = 'account_from_cash'
            AND DATE(ex.date) > ?
        ), 0) as cumulative_account_from_cash,





        -- Cumulative Expenses
        COALESCE((
            SELECT SUM(ex.amount) 
            FROM expenses ex
            WHERE ex.money_id = moneys.id 
            AND ex.isdelete = 0
            AND DATE(ex.date) > ?
        ), 0) as cumulative_expenses,



        -- Cumulative Sales
        COALESCE((
            SELECT SUM(sb.PaidAmount) 
            FROM bills sb
            WHERE sb.money_id = moneys.id 
            AND sb.isdelete = 0
            AND DATE(sb.dateInsert) > ?
        ), 0) as cumulative_sales,

        -- Cumulative Transaction count
        COALESCE(COUNT(CASE WHEN reports.type IN ('deposite','withdraw') 
            AND reports.isdelete = 0 
            AND DATE(reports.date_created) > ? THEN reports.id END), 0) as cumulative_qty
    ", [
                    // Daily totals parameters (8 pairs)
                    $startOfDay,
                    $endOfDay,
                    $startOfDay,
                    $endOfDay,
                    $startOfDay,
                    $endOfDay,
                    $startOfDay,
                    $endOfDay,
                    $startOfDay,
                    $endOfDay,
                    $startOfDay,
                    $endOfDay,$startOfDay,
                    $endOfDay,$startOfDay,
                    $endOfDay,

                    // Cumulative totals parameters (8 singles)
                    $date,
                    $date,
                    $date,
                    $date,
                    $date,
                    $date,
                    $date,
                    $date
                ])
                    ->leftJoin('belances', 'belances.type_id', '=', 'moneys.id')
                    ->leftJoin('reports', function ($join) use ($date) {
                        $join->on('reports.account_id', '=', 'belances.id')
                            ->where('reports.isdelete', 0)
                            ->whereRaw('DATE(reports.date_created) >= ?', [$date]);
                    })
                    ->groupBy('moneys.id', 'moneys.name', 'moneys.cach')
                    ->get()
                    ->map(function ($row) {
                        return [
                            'id' => $row->id,
                            'name' => $row->name,

                            // Cash balance calculation (using cumulative totals)
                            'cash' => $row->current_cash
                                - $row->cumulative_deposits
                                - $row->cumulative_sales
                                - $row->cumulative_account_from_cash
                                + $row->cumulative_cash_from_account
                                + $row->cumulative_withdraws
                                + $row->cumulative_purchases
                                + $row->cumulative_expenses,

                            'qty' => $row->cumulative_qty,

                            // Daily totals for deposit/withdraw display
                            'deposit' => $row->daily_deposits + $row->daily_sales +$row->daily_account_from_cash,
                            'withdraw' => $row->daily_withdraws + $row->daily_purchases + $row->daily_expenses+$row->daily_cash_from_account,

                            // Additional info if needed
                            'daily_qty' => $row->daily_qty
                        ];
                    });
            };


            // گرفتن داده‌های امروز و دیروز
            $todayResult = $getCashData($today);
            $yesterdayResult = $getCashData($yesterday);

            // گرفتن تراکنش‌های امروز

            // Reports (deposite / withdraw)
            $transactions = Report::with([
                'account.type' => function ($query) {
                    $query->select('account.name');
                }
            ])->whereDate('date_created', $today)
                ->where('isdelete', 0)
                ->where(function ($query) {
                    $query->where('type', 'deposite')
                        ->orWhere('type', 'withdraw');
                })
                ->with([
                    'account' => function ($query) {
                        $query->with('type');
                    }
                ])
                ->get()
                ->map(function ($transaction) {
                    return [
                        'id' => $transaction->id,
                        'type' => $transaction->type,
                        'money' => $transaction->account->type->name,
                        'amount' => $transaction->amount,
                        'description' => $transaction->discription,
                        'date_created' => $transaction->date_created,
                        'account_name' => $transaction->account->account->name ?? 'Unknown',
                        'source' => 'Report', // to know which model it came from
                    ];
                });

            // Purchase bills
            $purchaseTransactions = Purchasebills::with('accounts.account', 'money')->where('isdelete', 0)->whereDate('dateInsert', $today)
                ->get()
                ->map(function ($purchase) {
                    return [
                        'id' => $purchase->id,
                        'money' => $purchase->money->name,
                        'type' => 'purchase',
                        'amount' => $purchase->total,
                        'description' => 'Purchase Bill ' . ($purchase->temp_customer ?? $purchase->accounts->name),
                        'date_created' => $purchase->dateInsert,
                        'account_name' => $purchase->accounts?->account->name ?? 'temp',
                        'source' => 'PurchaseBill',
                    ];
                });


            // Expenses 
            $expanseTransactions = Expense::with('category', 'money')->where('isdelete', 0)->whereDate('date', $today)
                ->get()
                ->map(function ($purchase) {
                    return [
                        'id' => $purchase->id,
                        'money' => $purchase->money->name,
                        'type' => 'expense',
                        'amount' => $purchase->amount,
                        'description' => $purchase->description,
                        'date_created' => $purchase->date,
                        'account_name' => $purchase->category->name, // or join account if needed
                        'source' => 'expenses',
                    ];
                });

            // Sales bills
            $salesTransactions = Bill::with('money', 'accounts.account')->where('isdelete', 0)->whereDate('dateInsert', $today)
                ->get()
                ->map(function ($bill) {
                    return [
                        'id' => $bill->id,
                        'money' => $bill->money->name,
                        'type' => 'sale',
                        'amount' => $bill->total,
                        'description' => 'Sales Bill',
                        'date_created' => $bill->dateInsert,
                        'account_name' => $purchase->accounts?->account->name ?? 'temp', // or join account if needed
                        'source' => 'SaleBill',
                    ];
                });


        // Exchange transactions - cash_from_account (withdraw from account to cash)
        $exchangeWithdraws = Exchange::with(['toMoney', 'fromAccount.account'])
            ->where('isdelete', 0)
            ->whereDate('date', $today)
            ->where('type', 'cash_from_account')
            ->get()
            ->map(function ($exchange){
                return [
                    'id' => $exchange->id,
                    'money' => $exchange->fromMoney->name ?? 'Unknown',
                    'type' => 'exchange_withdraw',
                    'amount' => $exchange->from_amount,
                    'description' => $exchange->to_amount . ' ' . $exchange->toMoney->name,
                    'date_created' => $exchange->date,
                    'account_name' => $exchange->fromAccount->account->name ?? 'Unknown',
                    'source' => 'exchanges',
                ];
            });

        // Exchange transactions - account_from_cash (deposit from cash to account)
        $exchangeDeposits = Exchange::with('fromMoney', 'toAccount.account')
            ->where('isdelete', 0)
            ->whereDate('date', $today)
            ->where('type', 'account_from_cash')
            ->get()
            ->map(function ($exchange) {
                return [
                    'id' => $exchange->id,
                    'money' => $exchange->toMoney->name ?? 'Unknown',
                    'type' => 'exchange_deposit',
                    'amount' => $exchange->to_amount,
                    'description' => $exchange->from_amount . ' ' .$exchange->fromMoney->name,
                    'date_created' => $exchange->date,
                    'account_name' => $exchange->toAccount->account->name ?? 'Unknown',
                    'source' => 'exchanges',
                ];
            });



            // Merge all transactions into one collection
            $allTransactions = collect()
                ->merge($exchangeWithdraws)
                ->merge($expanseTransactions)
                ->merge($exchangeDeposits)
                ->merge($transactions)
                ->merge($purchaseTransactions)
                ->merge($salesTransactions)
                ->sortByDesc('date_created')
                ->values();

            // Now $allTransactions can be sent to a view to show in a table


            return response()->json([
                'today' => $todayResult,
                'yesterday' => $yesterdayResult,
                'transactions' => $allTransactions
            ]);
        }







        $query = Moneys::orderBy('id', 'desc');

        if ($account_id) {
            // بررسی وجود مشتری
            $customer = Accounts::find($account_id);
            if (!$customer) {
                return response()->json(['error' => 'Customer not found'], 404);
            }

            // گرفتن لیست کرنسی‌ها برای حساب‌های موجود در سیستم
            $usedCurrencies = Belances::where('account_id', $account_id)
                ->pluck('type_id')
                ->toArray();

            // پیدا کردن کرنسی‌هایی که هنوز استفاده نشده‌اند
            $currencies = Moneys::where('existense', 0)->whereNotIn('id', $usedCurrencies)
                ->get();

            return response()->json([
                'available_currencies' => $currencies
            ]);
        }

        //  "id"=> $this->id,
        //     'ontransaction'=>$this->ontransaction,
        //     'existense'=>$this->existense,
        //     'user'=>$this->user_id,
        //         'user_name'=>$this->user->name,
        //     'name'=>$this->name,
        //     'cach'=>$this->cach,



        // if ($isdelete==='1' || $isdelete==='0') {
        $query->where('existense', $isdelete);
        // }
        $moneys = $query->get(); // یا استفاده از همه رکوردها: $query->get()
        return response()->json(
            MoneyResource::collection(
                $moneys
            )
        );
    }
    public function store(Request $request)
    {
        $data = $this->getData($request);
        $moneyes = Moneys::create($data);
        $ownerbelnace = Belances::create([
            'ontransaction' => 1,
            'existense' => 0,
            'user_id' => $moneyes->user_id,
            'isdelete' => 0,
            'account_id' => 1,
            'type_id' => $moneyes->id,
            'belance' => 0,
        ]);
        $moneyes->ontransaction = 0;
        return response()->json([
            'money' => new MoneyResource($moneyes),
            'belance' => new BelanceResource($ownerbelnace),
            'message' => 'money created successfully.'
        ], 201);
    }

    public function show($id)
    {
        $moneys = Moneys::with('user')->findOrFail($id);
        return response()->json($moneys);
    }

    public function update($id, Request $request)
    {
        $data = $this->getData($request);
        $moneys = Moneys::findOrFail($id);
        $moneys->update($data);
        return response()->json($moneys);
    }

    public function destroy($id)
    {
        try {
            $moneys = Moneys::findOrFail($id);
            $moneys->delete();
            return response()->json(['message' => 'Moneys was successfully deleted.'], Response::HTTP_OK);
        } catch (Exception $exception) {
            return response()->json(['error' => 'Unexpected error occurred while trying to process your request.'], Response::HTTP_INTERNAL_SERVER_ERROR);
        }
    }

    protected function getData(Request $request)
    {
        $rules = [
            'ontransaction' => 'nullable',
            'existense' => 'nullable',
            'user_id' => 'nullable',
            'name' => 'nullable|string|min:1|max:255',
            'cach' => 'nullable|numeric|min:-9223372036854775800|max:9223372036854775800',
        ];

        $data = $request->validate($rules);
        // $data['ontransaction'] = $request->has('ontransaction');
        // $data['existense'] = $request->has('existense');

        return $data;
    }
}
