<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Http\Resources\StockResource;
use App\Models\Exchangetime;
use App\Models\Expense;
use App\Models\gold_rate;
use App\Models\gold_rate_time;
use App\Models\ItemType;
use App\Models\Purchase;
use App\Models\Rate;
use App\Models\Sell;
use App\Models\Sidebar;
use App\Models\User;
use App\Models\Moneys;
use App\Models\Belances;
use App\Models\Bill;
use App\Models\Purchasebills;
use App\Models\Report;
use App\Models\Item;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;
use Date;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Http\Request;
use Exception;
use Illuminate\Http\JsonResponse;

class ItemsController extends Controller
{
    /**
     * Display a listing of the items.
     *
     * @return JsonResponse
     */
    public function index(Request $request): JsonResponse
    {
        $search = $request->query('query');
        $filter = $request->query('search');
        $perPage = $request->query('perPage', 10); // مقدار پیش‌فرض 10
        $stock = $request->query('stock');
        $searchingStock = $request->query('searchingStock');
        $items = Item::with('type', 'user');
        $assets = $request->query('assets');
        if ($search && $stock) {
            $data = Item::with('type');
            $data = $data->where('qty', '>', '0');
            $data = $data->where('name', 'like', "%$search%")->get();
            return response()->json($data);
        }
        if ($search) {
            if (!empty($filter)) {
                $items->where(function ($query) use ($filter) {
                    $query->where('name', 'like', '%' . $filter . '%')
                        ->orWhere('serial_number', $filter);
                });
            }
            return response()->json($items->get());
        }
        if ($stock === 'true') {
            $items = Item::with('type', 'user')
                ->withSum('cabinStocks as qty', 'qty') // جمع ستون qty از CabinStock
                ->having('qty', '>', 0);   // فقط آیتم‌هایی که qty > 0 باشه;
            // $items = $items->where('qty', '>', 0);
            if ($searchingStock === 'true') {
                $items->where(function ($query) use ($filter) {
                    $query->where('name', 'like', '%' . $filter . '%')
                        ->orWhere('serial_number', $filter);
                });
                return response()->json($items->get());
            }
            if ($filter != 'false' && isset($filter)) {
                $items->where('name', 'like', "%$filter%");
            }
            if ($assets === 'ok' && isset($assets)) {
                $today = Carbon::now()->format('Y-m-d');
                // محاسبه مانده حساب اصلی (account_id = 1)
                $main_belance = Belances::where('account_id', 1)->get()
                    ->sum(fn($b) => $this->DailyRate($today, $b->type_id) * $b->belance);

                // آمار فروش، خرید، انتقال و تراکنش‌ها
                $sell = Bill::where('type', 'sell')->count();
                $purchase = Purchasebills::where('type', 'purchase')->count();
                $transformation = Report::where('type', 'from')->where('isdelete', 0)->count();
                $transaction = Report::whereIn('type', ['deposite', 'withdraw'])->where('isdelete', 0)->count();

                // محاسبه ارزش موجودی کالا (asset)

                $sidebars = Sidebar::first();
                if ($sidebars->type === 'gold') {
                    $sidebars = true;
                } else {
                    $sidebars = false;
                }
                $asset = 0;
                $items=$items->get();
                foreach ($items as $item) {
                    $qty = $item->qty;
                    $purchases = Purchase::where('isdelete', 0)
                        ->where('stocks_id', $item->id)
                        ->orderByDesc('id')
                        ->get();

                    foreach ($purchases as $purchase) {
                        $usedQty = $purchase->remainqty;
                        if ($sidebars) {
                            $goldTime = gold_rate_time::where('date', '<=', Carbon::parse($purchase->dateInsert)->format('Y-m-d'))->first();
                            if ($goldTime) {
                                $purchaseRate = gold_rate::where('date', $goldTime->id)->where('item_type', $purchase->stocks_id)->first();
                                $asset += $purchase->purchase_price * $usedQty * $purchaseRate->value;
                            } else {
                                $asset += $purchase->purchase_price * $usedQty;
                            }
                        } else {
                            $asset += $purchase->purchase_price * $usedQty;
                        }
                        $qty -= $usedQty;
                        if ($qty <= 0)
                            break;
                    }
                }

                // محاسبه سود (profit)
                $profit = 0;

                // foreach ($items as $item) {
                if ($sidebars) {
                    $sales = Sell::where('isdelete', 0)->orderBy('id')->get();
                    $goldTime = gold_rate_time::where('date', '<=', Carbon::parse($purchase->dateInsert)->format('Y-m-d'))->first();

                    if ($goldTime) {
                        foreach ($sales as $value) {
                            $purchaseRate = gold_rate::where('date', $goldTime->id)->where('item_type', $value->item_id)->first();
                            $selling = $value->sell_price * $value->qty * $purchaseRate->value;
                            $purchsing = $value->purchase_price * $value->qty;
                            $profit += $selling - $purchsing;
                        }
                    } else {
                        $profit = 0;

                        foreach ($sales as $value) {
                            // پیدا کردن نزدیک‌ترین تاریخ برای نرخ
                            $extime = Exchangetime::whereDate('date', '<=', $value->dateInsert)
                                ->orderBy('date', 'desc')
                                ->first();

                            $rate = $extime
                                ? Rate::where('date', $extime->id)->get()
                                : collect();

                            // محاسبه قیمت فروش
                            if ($value->money_id == 1) {
                                $sellPrice = $value->sell_price;
                            } else {
                                $find = $rate->firstWhere('money_id', $value->money_id);
                                if ($find && $find->from_amount && $find->to_amount) {
                                    $sellPrice = $value->sell_price * $find->from_amount / $find->to_amount;
                                } else {
                                    $sellPrice = $value->sell_price; // fallback
                                }
                            }

                            // محاسبه قیمت خرید
                            if ($value->money_id_purchase == 1) {
                                $purchasePrice = $value->purchase_price;
                            } else {
                                $find = $rate->firstWhere('money_id', $value->money_id_purchase);
                                if ($find && $find->from_amount && $find->to_amount) {
                                    $purchasePrice = $value->purchase_price * $find->from_amount / $find->to_amount;
                                } else {
                                    $purchasePrice = $value->purchase_price; // fallback
                                }
                            }

                            // محاسبه فروش کل و خرید کل با قیمت‌های تبدیل‌شده
                            $selling = $sellPrice * $value->qty;
                            $purchsing = $purchasePrice * $value->qty;

                            // جمع سود
                            $profit += $selling - $purchsing;
                        }

                    }

                } else {
                    $sales = Sell::where('isdelete', 0)->orderBy('id')->get();
                    $profit = 0;

                    foreach ($sales as $value) {
                        // پیدا کردن نزدیک‌ترین تاریخ برای نرخ
                        $extime = Exchangetime::whereDate('date', '<=', $value->dateInsert)
                            ->orderBy('date', 'desc')
                            ->first();

                        $rate = $extime
                            ? Rate::where('date', $extime->id)->get()
                            : collect();

                        // محاسبه قیمت فروش
                        if ($value->money_id == 1) {
                            $sellPrice = $value->sell_price;
                        } else {
                            $find = $rate->firstWhere('money_id', $value->money_id);
                            if ($find && $find->from_amount && $find->to_amount) {
                                $sellPrice = $value->sell_price * $find->from_amount / $find->to_amount;
                            } else {
                                $sellPrice = $value->sell_price; // fallback
                            }
                        }

                        // محاسبه قیمت خرید
                        if ($value->money_id_purchase == 1) {
                            $purchasePrice = $value->purchase_price;
                        } else {
                            $find = $rate->firstWhere('money_id', $value->money_id_purchase);
                            if ($find && $find->from_amount && $find->to_amount) {
                                $purchasePrice = $value->purchase_price * $find->from_amount / $find->to_amount;
                            } else {
                                $purchasePrice = $value->purchase_price; // fallback
                            }
                        }

                        // محاسبه فروش کل و خرید کل با قیمت‌های تبدیل‌شده
                        $selling = $sellPrice * $value->qty;
                        $purchsing = $purchasePrice * $value->qty;

                        // جمع سود
                        $profit += $selling - $purchsing;
                    }

                    $reports = Report::where('type', 'com')->sum('amount');
                    $profit += $reports;
                }

                // }

                // محاسبه موجودی نقدی
                $total_cash = Moneys::where('existense', 0)->get()
                    ->sum(fn($m) => $this->DailyRate($today, $m->id) * $m->cach);

                // محاسبه اعتبارات و بدهی‌ها
                $total_credit = Belances::where('belance', '>', 0)->where('account_id', '!=', 1)->get()
                    ->sum(fn($c) => $this->DailyRate($today, $c->type_id) * $c->belance);

                $total_debit = Belances::where('belance', '<', 0)->where('account_id', '!=', 1)->get()
                    ->sum(fn($d) => $this->DailyRate($today, $d->type_id) * $d->belance);

                // محاسبه کل هزینه‌ها
                $total_expense = Expense::where('isdelete', 0)->get()
                    ->sum(fn($ex) => $this->DailyRate($today, $ex->money_id) * $ex->amount);

                return response()->json([
                    'Totalassets' => $main_belance + $asset,
                    'cash' => $total_cash,
                    'mainBalance' => $main_belance,
                    'stock' => $asset,
                    'credit' => $total_credit,
                    'debit' => $total_debit,
                    'benefit' => $profit,
                    'expense' => $total_expense,
                    'data' => $items
                ]);
            }

            return response()->json($items->get());

        } else {
            $items = Item::with('type', 'user');
        }
        if ($filter != 'false') {
            $items->where('name', 'like', "%$filter%");
        }
        $reports = $items->paginate($perPage);
        return response()->json([
            'data' => $reports->items(),  // داده‌ها
            'total' => $reports->total(),  // تعداد کل رکوردها
            'current_page' => $reports->currentPage(),  // صفحه فعلی
            'per_page' => $reports->perPage(),  // تعداد آیتم‌ها در هر صفحه
            'last_page' => $reports->lastPage(),  // آخرین صفحه
        ], 200);
    }


    public function DailyRate($date, $money)
    {
        $purchaseTime = Exchangetime::where('date', Carbon::parse($date)->format('Y-m-d'))->first();
        $purchaseRate = Rate::where('date', optional($purchaseTime)->id)
            ->where('money_id', $money)
            ->value('from_amount');
        if (!$purchaseRate) {
            $purchaseTime = Exchangetime::orderBy('date', 'desc')->first();
            if ($purchaseTime) {
                return 1;
            }
            $purchaseRate = Rate::where('money_id', $money)->orderBy('')
                ->value('from_amount') || 1;
        }
        return $purchaseRate;
    }


    /**
     * Show the form for creating a new item (not applicable for API).
     *
     * @return JsonResponse
     */
    public function create(): JsonResponse
    {
        // This method is typically not needed in API as the creation is handled directly through store.
        return response()->json(['message' => 'Create item not applicable.']);
    }

    /**
     * Store a new item in the storage.
     *
     * @param Illuminate\Http\Request $request
     * @return JsonResponse
     */
    public function store(Request $request): JsonResponse
    {
        $data = $this->getData($request);

        try {
            // اطمینان از اینکه تاریخ به فرمت مناسب تبدیل می‌شود
            if (isset($data['date_creation'])) {
                $data['date_creation'] = Carbon::parse($data['date_creation'])->format('Y-m-d H:i:s');
            }

            $item = Item::create($data);

            return response()->json([
                'message' => 'Item created successfully.',
                'item' => $item,
            ], 201); // HTTP 201 Created
        } catch (Exception $e) {
            return response()->json([
                'error' => 'Failed to create item: ' . $e->getMessage(),
            ], 500);
        }
    }

    /**
     * Display the specified item.
     *
     * @param int $id
     * @return JsonResponse
     */
    public function show($id): JsonResponse
    {
        $item = item::with('itemtype', 'user')->findOrFail($id);
        return response()->json($item);
    }

    /**
     * Show the form for editing the specified item (not applicable for API).
     *
     * @param int $id
     * @return JsonResponse
     */
    public function edit($id): JsonResponse
    {
        // This method is typically not needed in API as the editing is handled directly through update.
        return response()->json(['message' => 'Edit item not applicable.']);
    }

    /**
     * Update the specified item in the storage.
     *
     * @param int $id
     * @param Illuminate\Http\Request $request
     * @return JsonResponse
     */
    public function update($id, Request $request): JsonResponse
    {
        $data = $this->getData($request);
        try {
            if (isset($data['date_creation'])) {
                // Remove 'Z' and convert to a format that Carbon can parse
                // $data['date_creation'] = rtrim($data['date_creation'], 'Z') . '+00:00';
                $data['date_creation'] = Carbon::parse($data['date_creation'])->format('Y-m-d H:i:s');
            }
        } catch (Exception $e) {
            return response()->json([
                'error' => 'Failed to create report'
            ], 500);
        }
        $item = item::findOrFail($id);
        $item->update($data);
        return response()->json(['message' => 'Item updated successfully.', 'item' => $item]);
    }

    /**
     * Remove the specified item from the storage.
     *
     * @param int $id
     * @return JsonResponse
     */
    public function destroy($id): JsonResponse
    {
        try {
            $item = item::findOrFail($id);
            $item->delete();

            return response()->json(['message' => 'Item deleted successfully.']);
        } catch (Exception $exception) {
            return response()->json(['error' => 'Unexpected error occurred while trying to process your request.'], 500);
        }
    }

    /**
     * Get the request's data from the request.
     *
     * @param Illuminate\Http\Request $request
     * @return array
     */
    protected function getData(Request $request): array
    {
        $rules = [
            'name' => 'nullable|string|max:255',
            'type_id' => 'nullable|numeric|min:0',
            'user_id' => '',
            'isdelete' => 'boolean',
            'description' => 'nullable|string',
            'date_creation' => '',
            'serial_number' => 'nullable|string|min:0|max:255',
            'rate' => 'nullable'
        ];

        $data = $request->validate($rules);
        $data['isdelete'] = $request->has('isdelete');

        return $data;
    }
}
