<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\gold_rate_time;
use App\Models\gold_rate;
use Carbon\Carbon;

class GoldRateTimeController extends Controller
{
        public function dateChange($date)
        {
                if ($date) {
                    try {
                        return Carbon::parse($date)->format('Y-m-d H:i:s');
                    } catch (\Exception $e) {
                        return response()->json(['error' => 'error'], 422);
                    }
                }
            
                return null; 
        }
    
    
    //
    public function index(Request $request)
    {
            $date=$request->query('date');
            $data= gold_rate_time::orderBy('date','desc')->where('date','=>',$date)
            ->first();
            $rate=gold_rate::where('date',$data->id)->getI();
            return response()->json($rate);
    }
    public function store(Request $request)
    {
          $date = $request->query('date');
        $validated = $request->validate([
            // اعتبارسنجی فیلد date به عنوان یک تاریخ (فرمت "YYYY-MM-DD" از سمت کلاینت تولید می‌شود)
            'date' => '',
            'user_id' => '',
            // آرایه rates باید اجباری باشد
            'rate' => 'array',
            // در هر آیتم از آرایه rates:
            //   - money_id اجباری است، باید عدد صحیح بوده و موجودیت آن در جدول money (ستون id) چک شود
            'rate.*.item_type' => '',
            //   - from_amount اجباری است و باید از نوع عددی باشد (در صورت نیاز می‌توانید قوانین بیشتری مثل min:0 اضافه کنید)
            'rate.*.value' => '',
        ]);
        $validated['date'] = $this->dateChange($validated['date']);
        $extime=gold_rate_time::where('date',$validated['date'])->first();
        if(!$extime){
            $extime=gold_rate_time::create([
                'date'=>$validated['date'],
                'user_id'=>$validated['user_id']
            ]);
        }
           foreach ($validated['rate'] as $row) {
               $find=gold_rate::where('date',$extime->id)->where('item_type',$row['item_type'])->first();
            if($find){
                $find->from_amount=$row['value'];
            }else{
               $res= gold_rate::create([
                'date' => $extime->id,
                'value' => $row['value'],
                'item_type' => $row['item_type']
            ]);
            }
        }
        return response()->json($validated, 201);
    }
    public function show($id,Request $request){
        $date = $request->query('date',date('Y-m-d'));
        // if ($date) {
            $data = gold_rate_time::where('date','<=', $date)->first();
            if($data){
                $goldrate= gold_rate::where('date', $data->id)->orderBy('id','desc')->first();
                return response()->json($goldrate);
            }
            else{
                return response()->json('Date not provided');
            }
        // }   
        // return response()->json(['message' => 'Date not provided'], 201);
    }
    public function update(Request $request, $id)
    {
        
      
        
    }
    public function destroy($id)
    {
        $data = gold_rate_time::find($id);
        if (!$data) {
            return response()->json(['message' => 'Gold rate time not found'], 404);
        }else {
            $data->delete();
            return response()->json(['message' => 'Gold rate time deleted successfully']);
        }
    }
}