<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Models\Accounts;
use App\Models\Bill;
use App\Models\Expense;
use App\Models\Moneys;
use App\Models\Purchasebills;
use App\Models\Report;
use App\Models\Item;
use App\Models\Belances;
// use App\Models\Expense;
// use App\Models\User;
use App\Http\Resources\BelanceResource;

use Illuminate\Http\Request;
use Exception;

class DashboardController extends Controller
{
    /**
     * Display a listing of the belances.
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function getDashboard(Request $request)
{
    $belance = Belances::where('isdelete',0)->count();
    $sell = Bill::where('type','sell')->count();
    $purchase = Purchasebills::where('type','purchase')->count();
    $transformation = Report::where('type','from')->where('isdelete',0)->count();
    $transaction = Report::where(function ($query) {
        $query->where('type', 'deposite')
              ->orWhere('type', 'withdraw');
    })
    ->where('isdelete', 0)
    ->count();
    $stock=Item::where('qty','>',0)->count();
    $money= Moneys::where('existense',0)->count();
    $credeit=Belances::where('belance','>',0)->count();
    $debit=Belances::where('belance','<',0)->count();
    $expense=Expense::count();

    return response()->json(
[
    'belance' => $belance,
    'sell' => $sell,
    'purchase' => $purchase,
    'transaction' => $transaction,
    'transformation' =>$transformation,
    'money'=>$money,
    'stock'=>$stock,
    'credit'=>$credeit,
    'debit'=>$debit,
    'expense'=>$expense
]);
}
// public function getSells(Request $request)
// {


//     return response()->json(
// $query
//     );
// }

    /**
     * Show the form for creating a new belance (not needed in API).
     */

    /**
     * Store a new belance in the storage.
     *
     * @param Illuminate\Http\Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function store(Request $request)
    {
        $data = $this->getData($request);
        if (isset($data['date_created'])) {
            // Remove 'Z' and convert to a format that Carbon can parse
            $data['date_created'] = rtrim($data['date_created'], 'Z') . '+00:00';
        }
        $customer=Accounts::where('id',$data['account_id'])->first();
        if(!$customer==null){
        $customer->ontransaction=1;
        }
        $customer->save();
        $belance = Belances::create($data);
        return response()->json([
            'message' => 'Belance created successfully.',
            'belance' => new BelanceResource($belance) ,
        ], 201);
    }


    /**
     * Update the specified belance in the storage.
     *
     * @param int $id
     * @param Illuminate\Http\Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function update($id, Request $request)
    {
        $data = $this->getData($request);
        if (isset($data['date_created'])) {
            // Remove 'Z' and convert to a format that Carbon can parse
            $data['date_created'] = rtrim($data['date_created'], 'Z') . '+00:00';
        }

        $belance = Belances::findOrFail($id);
        $belance->update($data);

        return response()->json([
            'message' => 'Belance updated successfully.',
        ]);
    }

    /**
     * Remove the specified belance from the storage.
     *
     * @param int $id
     * @return \Illuminate\Http\JsonResponse
     */
    public function destroy($id)
    {
        try {
            $belance = Belances::findOrFail($id);
            $belance->delete();

            return response()->json([
                'message' => 'Belance deleted successfully.'
            ]);
        } catch (Exception $exception) {
            return response()->json([
                'error' => 'Unexpected error occurred while trying to process your request.'
            ], 500);
        }
    }

    public function show($id)
    {
        $balance = Belances::findOrFail($id); // پیدا کردن موجودیت بر اساس ID
        $balanceResource = new BelanceResource($balance); // استفاده از BelanceResource برای موجودیت

        return response()->json($balanceResource); // ارسال پاسخ JSON
    }




    /**
     * Get the request's data from the request.
     *
     * @param Illuminate\Http\Request $request
     * @return array
     */
    protected function getData(Request $request)
    {
        $rules = [
            'ontransaction' => 'boolean',
            'user_id' => '',
            'isdelete' => 'boolean',
            'account_id' => 'nullable|numeric|min:0',
            'type_id' => 'nullable|numeric|min:0',
            'belance' => '',
            'date_created' => '',
            'time' => 'nullable|date_format:j/n/Y g:i A',
        ];
        $data = $request->validate($rules);
        return $data;
    }
}
