<?php namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\DB;
use Symfony\Component\HttpFoundation\StreamedResponse;

class BackupController extends Controller
{
    public function backupDatabase()
    {
        try {
            // نام دیتابیس
            $databaseName = DB::getDatabaseName();

            // نام فایل بک‌اپ
            $backupFileName = 'backup-' . date('Y-m-d-H-i-s') . '.sql';

            // مسیر ذخیره‌سازی موقت
            $backupPath = storage_path('app/backups/' . $backupFileName);

            // ایجاد پوشه اگر وجود ندارد
            if (!file_exists(dirname($backupPath))) {
                mkdir(dirname($backupPath), 0755, true);
            }

            // دستور بک‌اپ برای MySQL
            $command = sprintf(
                'mysqldump --user=%s --password=%s --host=%s %s > %s',
                env('DB_USERNAME'), // خواندن نام کاربری از .env
                env('DB_PASSWORD'), // خواندن رمز عبور از .env
                env('DB_HOST'),    // خواندن هاست از .env
                env('DB_DATABASE'), // خواندن نام دیتابیس از .env
                $backupPath
            );

            // اجرای دستور
            exec($command);

            // بررسی وجود فایل بک‌اپ
            if (!file_exists($backupPath)) {
                return response()->json(['error' => 'Backup failed'], 500);
            }

            // دانلود فایل بک‌اپ
            return response()->download($backupPath, $backupFileName)->deleteFileAfterSend(true);
        } catch (\Exception $e) {
            return response()->json(['error' => $e->getMessage()], 500);
        }
    }
}