<?php
namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Validation\ValidationException;
use Illuminate\Support\Facades\Auth;

class AuthController extends Controller
{
    // ثبت نام کاربر
    // public function register(Request $request)
    // {
    //     $request->validate([
    //         'name' => 'required|string|unique:users,name',
    //         'email' => 'required|string|email|unique:users,email',
    //         'password' => 'required|string|confirmed|min:6',
    //     ]);

    //     $user = User::create([
    //         'name' => $request->name,
    //         'email' => $request->email,
    //         'password' => Hash::make($request->password),
    //     ]);

    //     return response()->json(['message' => 'User registered successfully']);
    // }

    public function logout(Request $request)    
{
    $request->user()->currentAccessToken()->delete();

    return response()->json(['message' => 'Logged out successfully']);
}

    // لاگین کاربر
  public function login(Request $request)
    {
        $request->validate([
            'name' => 'required|string',
            'password' => 'required|string',
        ]);

        $user = User::where('name', $request->name)->first();

        if (!$user || !Hash::check($request->password, $user->password)) {
            return response()->json(['message' => 'Invalid credentials'], 401);
        }

        // حذف توکن‌های قبلی (برای امنیت)
        // $user->tokens()->delete();

        // ایجاد توکن جدید
        $token = $user->createToken('YourAppName')->plainTextToken;

        // بارگذاری نقش‌ها
        $roles = $user->getRoleNames(); // ['admin', 'editor' ...]

        // بارگذاری پرمیشن‌ها از نقش‌ها (مطمئن شو رول‌ها پرمیشن دارند)
        $permissions = $user->getAllPermissions()->pluck('name'); // بجای getPermissionNames()

        return response()->json([
            'token' => $token,
            'user' => [
                'id' => $user->id,
                'name' => $user->name,
                'email' => $user->email,
                'roles' => $roles,
                'permissions' => $permissions,
                'created_at' => $user->created_at,
                'updated_at' => $user->updated_at,
            ]
        ]);
    }
}
